@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">LISTA DE DEUDAS PENDIENTES POR COBRAR</h4>

      

            <div class="ui equal width grid">
                <div class="row">

                    <div class="column">
                        <form id="frmBuscar" autocomplete="off" method="GET" action="{{ url('proforma/buscar_deuda') }}" >
                            <div class="ui action small input" >
                                  <input type="text" placeholder="Buscar..." name="search">
                                  <button type="submit" class="ui icon button " title="Clic para buscar"><i class="search icon"></i></button>
                            </div>
                        </form>
                    </div>


                    <div class="column export_files" style="text-align: right">
                        <select class="ui small input dropdown" name="tipo_deuda">
                            <option value="1">DEUDAS DE PEDIDOS</option>
                            <option value="0">DEUDAS DE VENTAS</option>
                        </select>  
                    </div>
                </div>
            </div> 

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Sucursal</th>
                        <th class="head_table">Cliente</th>
                        <th class="head_table">Fecha de Emision</th>
                        <th class="head_table">Pedido</th>
                        <th class="head_table">Deuda S/</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $venta)
                    <tr data-table="{{ $venta->id_venta }}">
                        <td>{{ $i }}</td>
                        <td>{{ $venta->local->nombre }}</td>
                        <td>{{ $venta->nombre }}</td>
                        <td>{{ $venta->fecha_emision}}</td>
                        <td>{{ $venta->tipo}} N° {{ $venta->id_proforma}} </td>
                        <td style="color: red">{{ $venta->saldo}}</td>
                        <td>                            
                            {{-- <div class="ui mini vertical animated positive button button_info_modal" title="Ver informacion detallada" data-id="{{ $compra->id_compra }}">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </div> --}}
                            <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('proforma/detalles_deuda/'.$venta->id_proforma) }}">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </a>
                           {{--  <div class="ui mini vertical animated red button button_delete_modal" title="Eliminar registro" data-id="{{ $compra->id_compra }}">
                                <div class="hidden content">Eliminar</div>
                                <div class="visible content"><i class="trash alternate icon"></i></div>
                            </div> --}}
                      
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="7">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop

@section('scripts')
    <script src="{{ asset('js/venta/listar_deuda.js') }}"></script>
@stop


